/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import org.python.core.io.BufferedIOMixin;
import org.python.core.io.RawIOBase;

public class BufferedReader
extends BufferedIOMixin {
    protected ByteBuffer buffer;

    public BufferedReader(RawIOBase rawIOBase, int n) {
        super(rawIOBase, n);
        rawIOBase.checkReadable();
        this.buffer = ByteBuffer.allocate(this.bufferSize);
        this.clear();
    }

    public int readinto(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        if (this.buffer.remaining() >= n) {
            int n2 = this.buffer.limit();
            this.buffer.limit(this.buffer.position() + n);
            byteBuffer.put(this.buffer);
            this.buffer.limit(n2);
            return n;
        }
        byteBuffer.put(this.buffer);
        this.buffer.clear();
        long l = this.rawIO.readinto(new ByteBuffer[]{byteBuffer, this.buffer});
        return (int)(l -= (long)this.buffer.flip().limit());
    }

    public ByteBuffer readall() {
        ByteBuffer byteBuffer = this.rawIO.readall();
        if (!this.buffer.hasRemaining()) {
            return byteBuffer;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.buffer.remaining() + byteBuffer.remaining());
        byteBuffer2.put(this.buffer);
        this.clear();
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    public ByteBuffer peek(int n) {
        if (this.buffer.remaining() < Math.min(n, this.bufferSize)) {
            if (this.buffer.position() == 0) {
                this.buffer.limit(this.buffer.capacity());
            } else {
                this.buffer.compact();
            }
            this.rawIO.readinto(this.buffer);
            this.buffer.flip();
        }
        return this.buffer;
    }

    public int read1(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n == 0) {
            return 0;
        }
        if (this.bufferSize > 0) {
            this.peek(1);
            int n2 = this.buffer.remaining();
            if (n2 < n) {
                byteBuffer.limit(byteBuffer.position() + n2);
            }
        }
        return this.readinto(byteBuffer);
    }

    public long tell() {
        return this.rawIO.tell() - (long)this.buffer.remaining();
    }

    public long seek(long l, int n) {
        if (n == 1) {
            l -= (long)this.buffer.remaining();
        }
        l = this.rawIO.seek(l, n);
        this.clear();
        return l;
    }

    public boolean buffered() {
        return this.buffer.hasRemaining();
    }

    public void clear() {
        this.buffer.clear().limit(0);
    }

    public int write(ByteBuffer byteBuffer) {
        this.checkClosed();
        this.checkWritable();
        return -1;
    }

    public boolean writable() {
        return false;
    }
}

